# Player: huggingface_DeepSeek-V3-0324_PayoffMaximizer_B (as Player B)
# Meta-Round: 5
# Experiment: PMxPM, Run: 5
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek_V3_0324_PayoffMaximizer_B_MR5_strategy.txt
# LLM Suggested Fallback: Not Provided

def huggingface_DeepSeek_V3_0324_PayoffMaximizer_B_MR5(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    current_round = len(my_history) + 1
    
    # Early Rounds (1-3)
    if current_round == 1:
        return "D"
    elif current_round <= 3:
        return "C"
    
    # Mid Rounds (4-7)
    elif current_round <= 7:
        if current_round <= 5:
            # Check if opponent cooperated in rounds 2-3
            if len(opp_history) >= 2 and opp_history[1] == "C" and opp_history[2] == "C":
                return "C"
            else:
                return "D"
        else:  # Rounds 6-7
            # Count opponent's defections in first 5 rounds
            defections = opp_history[:5].count("D")
            if defections > 1:
                return "D" if current_round % 2 == 0 else "C"
            else:
                return "C" if current_round % 2 == 0 else "D"
    
    # Late Rounds (8-10)
    else:
        # Check if opponent cooperated in at least 6 of first 7 rounds
        if len(opp_history) >= 7 and opp_history[:7].count("C") >= 6:
            if current_round == 9:
                return "C"
            else:
                return "D"
        else:
            return "D"